#include <arpa/inet.h>
#include <netinet/ip.h>
//#include <netinet/tcp.h>
#include <linux/tcp.h>

#include <sys/socket.h>
#include <sys/syscall.h>
#include <unistd.h>
#include <locale.h>

#include <stdlib.h>
#include <stdio.h>

#include <errno.h>

static inline void printsockinfo(int sfd)
{
	int prio;
	int dscp;
	int ka;
	int kidle;
	socklen_t optlen;
	struct tcp_info tcpi;
	int myerrno;

	optlen = sizeof(int);
	if (getsockopt(sfd, SOL_SOCKET, SO_PRIORITY, &prio, &optlen))
	{
		myerrno = errno;
		perror("SOL_SOCKET getsockopt()");
		_exit(myerrno);
	}

	optlen = sizeof(int);
	if (getsockopt(sfd, IPPROTO_IP, IP_TOS, &dscp, &optlen))
	{
		myerrno = errno;
		perror("IPPROTO_IP getsockopt()");
		_exit(myerrno);
	}

	optlen = sizeof(int);
	if (getsockopt(sfd, SOL_SOCKET, SO_KEEPALIVE, &ka, &optlen))
	{
		myerrno = errno;
		perror("SOL_SOCKET getsockopt()");
		_exit(myerrno);
	}

	optlen = sizeof(int);
	if (getsockopt(sfd, IPPROTO_TCP, TCP_KEEPIDLE, &kidle, &optlen))
	{
		myerrno = errno;
		perror("IPPROTO_TCP getsockopt()");
		_exit(myerrno);
	}

	optlen = sizeof(struct tcp_info);
	if (getsockopt(sfd, IPPROTO_TCP, TCP_INFO, &tcpi, &optlen))
	{
		myerrno = errno;
		perror("IPPROTO_TCP TCP_INFO getsockopt()");
		_exit(myerrno);
	}
	

	printf("priority = %i, dscp = %02x, keepalive = %i, kidle = %i\n", prio, dscp, ka, kidle);
	printf("\t\trtt = %'u\n\t\trtt-min = %'u\n\t\trtt-var = %'u\n\t\tcwnd = %'u\n\t\tpacing rate = %'llu\n\t\tmax pacing rate = %'llu\n\t\trx-bytes = %'llu\n\t\ttx-bytes = %'llu\n\t\tnotsent-bytes = %'u\n\t\tsegs out = %'u\n\t\tretrans = %'u\n\t\tsmss = %u\n\t\trmss = %u\n\t\tpmtu %u\n", tcpi.tcpi_rtt, tcpi.tcpi_min_rtt, tcpi.tcpi_rttvar, tcpi.tcpi_snd_cwnd, tcpi.tcpi_pacing_rate, tcpi.tcpi_max_pacing_rate, tcpi.tcpi_bytes_received, tcpi.tcpi_bytes_sent, tcpi.tcpi_notsent_bytes, tcpi.tcpi_segs_out, tcpi.tcpi_total_retrans, tcpi.tcpi_snd_mss, tcpi.tcpi_rcv_mss, tcpi.tcpi_pmtu);
}

int main(int argc, char *argv[])
{
	pid_t pid;
	int fd;
	char *endptr;
	int pidfd;
	int sock;
	int myerrno;

	if (argc != 3)
	{
		printf("Usage:\n\t%s PID FILE_DESCRIPTOR_NUM\n\nDisplays the socket info (including dscp) for a socket in a process with a given\nPID and FILE_DESCRIPTOR_NUM.\n", argc ? argv[0] : "UNKNOWN");
		return EINVAL;
	}

	setlocale(LC_ALL, "");

	pid = strtoul(argv[1], &endptr, 0);
	if (*endptr)
	{
		myerrno = errno;
		puts("unable to parse PID");
		if (!myerrno)
		{
			return EINVAL;
		}
		return myerrno;
	}

	fd = strtoul(argv[2], &endptr, 0);
	if (*endptr)
	{
		myerrno = errno;
		puts("unable to parse FILE_DESCRIPTOR_NUM");
		if (!myerrno)
		{
			return EINVAL;
		}
		return myerrno;
	}

	pidfd = syscall(SYS_pidfd_open, pid, 0);
	if (pidfd == -1)
	{
		myerrno = errno;
		perror("pidfd_open()");
		return myerrno;
	}

	sock = syscall(SYS_pidfd_getfd, pidfd, fd, 0);
	if (sock == -1)
	{
		myerrno = errno;
		close(pidfd);
		perror("pidfd_getfd()");
		return myerrno;
	}

	printsockinfo(sock);

	//I hope this doesn't fucking close the fd
	//for everybody!
	close(sock);
	close(pidfd);
	

	return 0;
}
